/******************************************************
 * Processor module implementation file.              *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/

#include "nios32_parms.H"
#include "nios32_arch.H"
#include "nios32.H"
#include <signal.h>

#include <ac_sighandlers.H>

//! Initialization (2 arguments).
void nios32::init(int ac, char** av)
{
 extern char* appfilename;
 ac_init_opt(ac, av);
 ac_init_app(ac, av);
 APP_MEM->load(appfilename);
 time_step = period / (sc_get_default_time_unit()).to_double();
 set_args(ac_argc, ac_argv);
 isa._behavior_begin();
 cerr << "ArchC: -------------------- Starting Simulation --------------------" << endl;
 InitStat();

 signal(SIGINT, sigint_handler);
 signal(SIGTERM, sigint_handler);
 signal(SIGSEGV, sigsegv_handler);
 signal(SIGUSR1, sigusr1_handler);
#ifdef USE_GDB
 signal(SIGUSR2, sigusr2_handler);
#endif
 set_running();
 return;
}

//! Initialization (no arguments).
void nios32::init()
{
 time_step = period / (sc_get_default_time_unit()).to_double();
 set_args(ac_argc, ac_argv);
 isa._behavior_begin();
 cerr << "ArchC: -------------------- Starting Simulation --------------------" << endl;
 InitStat();

 signal(SIGINT, sigint_handler);
 signal(SIGTERM, sigint_handler);
 signal(SIGSEGV, sigsegv_handler);
 signal(SIGUSR1, sigusr1_handler);
#ifdef USE_GDB
 signal(SIGUSR2, sigusr2_handler);
#endif
 set_running();
 return;
}

//! Stop simulation (may receive exit status).
void nios32::stop(int status)
{
 cerr << "ArchC: -------------------- Simulation Finished --------------------" << endl;
 isa._behavior_end();
 ac_stop_flag = 1;
 ac_exit_status = status;
 set_stopped();
 ac_arch<nios32_parms::ac_word, nios32_parms::ac_Hword>::PrintStat();
 return;
}

void nios32::load(char* program)
{
 APP_MEM->load(program);
 return;
}

void nios32::delayed_load(char* program)
{
 has_delayed_load = true;
 delayed_load_program = new char[strlen(program)];
 strcpy(delayed_load_program, program);
 return;
}

//! PrintStat wrapper method.
void nios32::PrintStat()
{
 ac_arch<nios32_parms::ac_word, nios32_parms::ac_Hword>::PrintStat();
 return;
}

//! Verification method.
void nios32::ac_verify()
{
#ifdef AC_VERBOSE
 DM.change_dump(cerr);
 RB.change_dump(cerr);
 IF_ID.change_dump(cerr);
 ID_EX.change_dump(cerr);
 EX_MEM.change_dump(cerr);
 MEM_WB.change_dump(cerr);
 ctl0.change_dump(cerr);
 ctl1.change_dump(cerr);
 ctl2.change_dump(cerr);
 ctl3.change_dump(cerr);
 ctl4.change_dump(cerr);
 ctl5.change_dump(cerr);
 ctl6.change_dump(cerr);
 ctl7.change_dump(cerr);
 ctl8.change_dump(cerr);
 ctl9.change_dump(cerr);
 pc.change_dump(cerr);
 k.change_dump(cerr);
#endif
#ifdef AC_UPDATE_LOG
 DM.reset_log();
 RB.reset_log();
 IF_ID.reset_log();
 ID_EX.reset_log();
 EX_MEM.reset_log();
 MEM_WB.reset_log();
 ctl0.reset_log();
 ctl1.reset_log();
 ctl2.reset_log();
 ctl3.reset_log();
 ctl4.reset_log();
 ctl5.reset_log();
 ctl6.reset_log();
 ctl7.reset_log();
 ctl8.reset_log();
 ctl9.reset_log();
 pc.reset_log();
 k.reset_log();
#endif
 if (pipe_IF.will_stall())
 {
  ac_pc.suspend();
  ac_instr_counter--;
 }
 if (pipe_ID.will_stall())
 {
  ac_pc.suspend();
  ac_instr_counter--;
 }
 if (pipe_EX.will_stall())
 {
  ac_pc.suspend();
  ac_instr_counter--;
 }
 if (pipe_MEM.will_stall())
 {
  ac_pc.suspend();
  ac_instr_counter--;
 }
 return;
}

